<?php if(!isset($portal)) die();?>
<!DOCTYPE html>
<html>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=windows-1250">
    <meta charset="utf-8">
    <link rel="stylesheet" type="text/css" href="css/style.css">
    <title>Portal</title>
  </head>
  <body>
  
    <div id="topDiv" class="scafoldingDiv">
      <div id="headerMainDiv">
        <a href="index.php">Gwna</a> |
        <a href="index.php?action=showNewsList">Lista nowoci</a>
        <?php if($portal->zalogowany): ?>
          | <a href="index.php?action=showSubscriptions">Subskrypcje</a>
        <?php endif; ?>
      </div>
      <div id="headerUserInfoDiv">
        <?php if($portal->zalogowany): ?>
          <div>Jeste zalogowany jako: <?=$portal->zalogowany->nazwa?></div>
          <div><a href="index.php?action=logout">Wylogowanie</a></div>
        <?php else: ?>
          <div>Nie jeste zalogowany.</div>
          <div><a href="index.php?action=showLoginForm">Logowanie</a></div>
        <?php endif ?>
      </div>
    </div>
    
    <div id="centerDiv" class="scafoldingDiv">
      <div id="mainContentDiv">
        <?php
          switch($action):
            case 'showLoginForm' :
              include 'templates/loginForm.php';
              break;
            case 'showFullStats' :
              echo $portal->getFullStats();
              include 'templates/statsForm.php';
              break;
            case 'showNewsList':
              $portal->showNewsList(ROWS_ON_PAGE);
              break;
            case 'showNews' :
              $news = $portal->getNews();
              include 'templates/singleNewsTemplate.php';
              break;
            case 'showSubscriptions';
              $portal->showSubscriptions($komunikat);
              break;
            case 'showMain':
            default:
              include 'templates/innerContentDiv.php';
          endswitch;
        ?>
      </div>
      
      <div id="rightSideDiv">
        <div class="header">Nowoci</div>
        <div class="content">
          <?php 
            if($newsHeaders){
              include 'templates/newsHeaders.php';
            } else {
              echo 'Brak nowoci';
            }
          ?>
        </div>
      </div>
    </div>
    
    <div id="footerDiv" class="scafoldingDiv">
      <div>
        <?php if($stats = $portal->getShortStats($timeout)):?>
          W cigu ostatnich <?=$stats['timeout']?> minut stron odwiedzio
          <?=$stats['allUsers']?> goci, w tym <?=$stats['regUsers']?> 
          zarejestrowanych uytkownikw.
        <?php else:?>
          Statystyki nie s dostpne.
        <?php endif;?>
      </div>
      <div>Zobacz pozostae
        <a href="index.php?action=showFullStats">statystyki</a>.</div>
    </div>
    
  </body>
</html>
